<?php
// login_step1.php
session_start();
require 'db_connection.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var(trim($_POST['email'] ?? ''), FILTER_SANITIZE_EMAIL);
    $password = $_POST['password'] ?? '';

    // 1. Check if the user exists and is active
    $stmt = $pdo->prepare("SELECT user_id, password_hash FROM users WHERE email = ? AND status = 'active'");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password_hash'])) {
        
        // 2. Generate a random 6-digit OTP
        $otp_code = random_int(100000, 999999);
        $expires_at = date('Y-m-d H:i:s', strtotime('+10 minutes'));

        // 3. Save the OTP to the database (linked to the email)
        $insert_stmt = $pdo->prepare("INSERT INTO otp_tokens (email, otp_code, expires_at) VALUES (?, ?, ?)");
        $insert_stmt->execute([$email, $otp_code, $expires_at]);

        // 4. MOCK EMAIL FOR LOCAL TESTING
        // Since XAMPP can't send real emails easily, we write the OTP to a text file.
        // You will open "mock_email_inbox.txt" in your folder to read your code!
        $mock_email_content = "-----------------------\n";
        $mock_email_content .= "To: $email\n";
        $mock_email_content .= "Time: " . date('H:i:s') . "\n";
        $mock_email_content .= "Your NCDC OTP Code is: $otp_code\n";
        $mock_email_content .= "-----------------------\n";
        file_put_contents('mock_email_inbox.txt', $mock_email_content, FILE_APPEND);

        // Tell the frontend to show the OTP input screen
        echo json_encode(['status' => 'success', 'user_id' => $user['user_id']]);
        exit;
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid email or password.']);
        exit;
    }
}
?>